using System;
using System.Drawing;
using System.Text;
using System.IO;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Collections.Specialized;
using System.Windows.Forms;
using System.Reflection;

using Borland.Studio.ToolsAPI;
using Borland.Studio.Host;

using Borland.Eco.Services;
using Borland.Eco.UmlRt;
using Borland.Eco.Handles;
using Borland.Eco.Handles.Design;
using Borland.Eco.Persistence.Design;
using Borland.Eco.WinForm;

namespace Borland.Eco.Examples.EcoSpaceDesignerPlugins
{
	[ToolboxBitmap(typeof(ValidateForms), "Borland.Eco.Examples.EcoSpaceDesignerPlugins.ValidateForms.bmp")]
	public class ValidateForms: DBToolBase
	{
#region Registration
		public static void IDERegister()
		{
			EcoSpaceDesignerToolbox.AddTool(new ValidateForms());
		}
#endregion

#region Implementation of IEcoSpaceDesignerTool
		public override string GetHint()
		{
			return "Validate forms";
		}
		private IEcoTypeSystem m_Model;
		public override void Execute(ExecuteArgs executeArgs)
		{
			// Extract TypeSystemService from executeArgs, get the TypeSystem and hold on to it.
			// This will be required to get to the predefined types for boolean and maybe some more.
			m_Model = GetTypeSystemService(executeArgs).TypeSystem;
			MessageHelper.AddMessage("Start validating forms.");
			ValidateProject();
			MessageHelper.AddMessage("Done validating forms.");
		}
#endregion

		private bool ValidateExpression(string rootContext, string property, object component, ITypeService typeService, string expression, IClassifier context, IClassifier expectedType)
		{
			if (expression == null || expression.Length == 0) return true;
			try
			{
				// Evaluate expression for type and if it didn't yield exception, assume it's OK.
				IClassifier resultClassifier = typeService.ExpressionType(expression, context, true);
				if (expectedType != null && resultClassifier != expectedType)
					MessageHelper.AddMessage(string.Format("{0} - {1} | {2} - {3}", rootContext, component.ToString(), property, string.Format("Expected type {0} but found {1}", expectedType.Name, resultClassifier.Name)));
				return true;
			}
			catch (Exception e)
			{
				MessageHelper.AddMessage(string.Format("{0} - {1} | {2} - {3}", rootContext, component.ToString(), property, e.Message));
				return false;
			}
		}
		private bool ValidateEcoComponent(string rootContext, IHasEditableExpression c)
		{
			if (c == null) return true;

			ITypeService typeService = null;
			switch (c.ExpressionKind)
			{
				case ExpressionKind.Ocl:
					typeService = c.StaticContext.OclTypeService;
					break;
				case ExpressionKind.OclPs:
					typeService = c.StaticContext.OclPsTypeService;
					break;
				case ExpressionKind.EcoActionLanguage:
					typeService = c.StaticContext.ActionLanguageTypeService;
					break;
			}

			return ValidateExpression(rootContext, "Expression", c, typeService, c.Expression, c.StaticContext.StaticUmlType, null); 
		}
		
		private bool ValidateListActionExtendees(string rootContext, EcoListActionExtender extender, ComponentCollection components)
		{
			bool result = true;
			for (int i = 0; i < components.Count; i++)
			{
				Component c = components[i] as Component;
				if (extender.CanExtend(c))
				{
					IStaticContext staticContext = extender.StaticContextForObject(c);
					if (staticContext != null)
					{
						// Go from a list to a single element.
						IClassifier context = staticContext.StaticUmlType;
						if (context != null)
						{
							if (context.ClassifierType == ClassifierType.Collection)
								context = ((ICollectionType)context).ElementType;

							result &= ValidateExpression(rootContext, "ActionOcl", c, staticContext.ActionLanguageTypeService, extender.GetActionExpression(c), context, null);
							result &= ValidateExpression(rootContext, "EnabledOcl", c, staticContext.OclTypeService, extender.GetEnabledOcl(c), context, m_Model.PredefinedTypes.Boolean);
							result &= ValidateExpression(rootContext, "VisibleOcl", c, staticContext.OclTypeService, extender.GetVisibleOcl(c), context, m_Model.PredefinedTypes.Boolean);
						}
					}
				}
			}
			return result;
		}
		
		private bool ValidateElementHandle(string rootContext, ElementHandle handle)
		{
			bool result = true;
			for (int i = 0; i < handle.Columns.Count; i++)
				result &= ValidateEcoComponent(rootContext, handle.Columns[i] as OclColumn);
			return result;
		}

		private bool ValidateComponent(string rootContext, IComponent c, ComponentCollection components)
		{
			bool result = true;
			if (c is ElementHandle)
				result &= ValidateElementHandle(rootContext, c as ElementHandle);
			if (c is IHasEditableExpression)
				result &= ValidateEcoComponent(rootContext, c as IHasEditableExpression);
			else if (c is EcoListActionExtender)
				result &= ValidateListActionExtendees(rootContext, c as EcoListActionExtender, components);
			return result;
		}

		private bool ValidateHost(BorlandDesignerHost host)
		{
			ComponentCollection components = host.RootComponent.Site.Container.Components;
			
			if (components == null) return true;
			bool result = true;
			for (int i = 0; i < components.Count - 1; i++)
			{
				result &= ValidateComponent(host.RootComponentClassName, components[i], components);
			}
			return result;
		}
		private void ValidateProject()
		{
			// Get hold of project
			IOTAModuleServices services = BorlandIDE.GetService(typeof(IOTAModuleServices)) as IOTAModuleServices;
			IOTAProject project = services.ActiveProject;
			//  Traverse all modules
			for (int i = 0; i < project.ModuleCount - 1; i++)
			{
				IOTAModuleInfo moduleInfo = project.GetModuleInfo(i);
				// Skip some obvious non-validatable modules.
				if (moduleInfo.FileName.EndsWith(".dll") ||
						moduleInfo.FileName.EndsWith(".resx") ||
						moduleInfo.FileName.EndsWith(".txaPackage") ||
						moduleInfo.FileName.EndsWith(".ecopkg") ||
						moduleInfo.FileName.EndsWith(".nfm") ||
						moduleInfo.FileName.EndsWith(".dfm") ||
						moduleInfo.FileName.EndsWith(".txvpck")) continue;

				// OPen the module and get to the dotnet module
				IOTAModule module = moduleInfo.OpenModule();
				IOTADotNetModule dotnetModule = (IOTADotNetModule)module.GetService(typeof(IOTADotNetModule));

				// If we got a dotnetmodule that can be designed, go ahead
				if (dotnetModule != null && dotnetModule.HasDesignableType)
				{
					// Keep track of opened state
					bool InitiallyShowing = dotnetModule.DesignerActive;
					if (!dotnetModule.ShowDesigner()) continue;

					BorlandDesignerHost host = dotnetModule.DesignerHost as BorlandDesignerHost;

					if (host != null)
					{
						bool validationOK = ValidateHost(host);
						//if (validationOK && !InitiallyShowing)
						//	dotnetModule.CloseDesigner(); // no such API?
					}
				}
			}
		}
	}
}